REM Base name
SET SAMPLE=%1
REM Absolute path for the location of RIETAN64.exe, seconds.exe, ALBA64.exe, etc.
SET RIETAN=C:\Program Files\RIETAN_VENUS
REM Absolute path for the location of ALBA.exe
SET ALBA=C:\Program Files\RIETAN_VENUS\
SET PATH=C:\Program Files\RIETAN_VENUS\Commands;%PATH%

rem save history files (*_1.ins, *_2.ins, ...)
if not exist "num.txt" echo 0 >"num.txt"
for /F %%i in (num.txt) do set NUM=%%i
copy /y "%SAMPLE%.ins" "%SAMPLE%_%NUM%.ins"
set /a NUM=%NUM% + 1
echo %NUM% >num.txt

FOR /F "USEBACKQ" %%T IN (`"%RIETAN%\seconds.exe"`) DO SET BEFORE=%%T
IF EXIST "%RIETAN%\RIETAN64.exe" (
   "%RIETAN%\RIETAN64.exe" "%SAMPLE%.ins" "%SAMPLE%.int" "%SAMPLE%.bkg" "%SAMPLE%.itx" "%SAMPLE%.hkl" "%SAMPLE%.xyz" "%SAMPLE%.fos" "%SAMPLE%.ffe" "%SAMPLE%.fba" "%SAMPLE%.ffi" "%SAMPLE%.ffo" "%SAMPLE%.vesta" "%SAMPLE%.plt" "%SAMPLE%.gpd" "%SAMPLE%.alb" "%SAMPLE%.prf" "%SAMPLE%.inflip" "%SAMPLE%.exp" | "%RIETAN%\Commands\tee.exe" "%SAMPLE%.lst"
) ELSE (
   "%RIETAN%\RIETAN.exe" "%SAMPLE%.ins" "%SAMPLE%.int" "%SAMPLE%.bkg" "%SAMPLE%.itx" "%SAMPLE%.hkl" "%SAMPLE%.xyz" "%SAMPLE%.fos" "%SAMPLE%.ffe" "%SAMPLE%.fba" "%SAMPLE%.ffi" "%SAMPLE%.ffo" "%SAMPLE%.vesta" "%SAMPLE%.plt" "%SAMPLE%.gpd" "%SAMPLE%.alb" "%SAMPLE%.prf" "%SAMPLE%.inflip" "%SAMPLE%.exp" | "%RIETAN%\Commands\tee.exe" "%SAMPLE%.lst"
)

REM MEP=0: "MEP = 1" is not included in hoge.lst
REM MEP=1: "MEP = 1" is included in hoge.lst
SET MEP=0
REM TOKENS=3: if "MEP = 1" is included in hoge.lst, the third string, "1", is selected.
FOR /F "TOKENS=3 USEBACKQ" %%T IN (`FINDSTR /R /C:"^ *MEP = 1$" "%SAMPLE%.lst"`) DO SET MEP=%%T

REM NCF must be determined prior to 'IF "%MEP%"=="1" ('
REM NCF=0: "NCF = 1" is not included in hoge.lst
REM NCF=1: "NCF = 1" is included in hoge.lst
SET NCF=0
FOR /F "TOKENS=3 USEBACKQ" %%T IN (`FINDSTR /R /C:"^ *NCF = 1$" "%SAMPLE%.lst"`) DO SET NCF=%%T

IF "%MEP%"=="1" (
   REM Analyze |Fo|^2 data in hoge.ffo by the maximum-entropy Patterson method to create hoge.mep
   IF EXIST "%ALBA%ALBA64.exe" (
      "%ALBA%ALBA64.exe" "%SAMPLE%.alb"
   ) ELSE (
      "%ALBA%ALBA.exe" "%SAMPLE%.alb"
   )
   FOR /F "USEBACKQ" %%T IN (`"%RIETAN%\seconds.exe"`) DO SET AFTER=%%T
   REM temp.txt: a scratch file to store parts of hoge.lst, hoge.out, and hoge.mep
   sed -e "/^ *\*\*\* End of job *\*\*\*/,$d" "%SAMPLE%.lst" > temp.txt
   REM Lines from line No. 23 to a line containing " Number of cycles" in hoge.out are appended to temp.txt
   sed -n -e "23,/^ Number of cycles/p" "%SAMPLE%.out" >> temp.txt
   ECHO.>>temp.txt
   ECHO.>>temp.txt
   ECHO  ************** Results of maximum-entropy Patterson analysis ***************>>temp.txt
   ECHO.>>temp.txt
   ECHO.>>temp.txt
   REM '|' and '^' must be escaped with '^'. Never insert a space between "Io" and ">>".
   ECHO    h   k   l           FWHM         ^|Fc^|^^2            d      2-theta             I       I/I1            Io>>temp.txt
   sed -n -e "2,$p" "%SAMPLE%.mep" >> temp.txt
   REM Append three line feeds, "       *** End of job ***", and two line feeds to temp.txt
   tail -n 9 "%SAMPLE%.lst" | sed -n -e "1,6p" >> temp.txt
   CALL :elapsed_time
   REM The version number of RIETAN-FP is output
   tail -n 2 "%SAMPLE%.lst" >> temp.txt
   DEL "%SAMPLE%.lst"
   REM Overwrite hoge.lst without any confirmation
   MOVE /Y temp.txt "%SAMPLE%.lst"
   REM After excution of the above command, temp.txt no longer exists in the current folder
   IF "%NCF%"=="1" (
      REM Replace |Fo|^2 in hoge.inflip with |Fc|^2 resulting from maximum-entropy Patterson analysis
      sed -n -e "1,/^fbegin/p" "%SAMPLE%.inflip" > temp.txt
      ECHO #  h   k   l           FWHM         ^|Fc^|^^2>>temp.txt
      REM Append columns No. 1-42 in hoge.mep to temp.txt
      sed -n -e "2,$p" "%SAMPLE%.mep" | cut -b 1-42 >> temp.txt
      ECHO endf>>temp.txt
      REM Overwrite hoge.inflip without any confirmation
      MOVE /Y temp.txt "%SAMPLE%.inflip"
   )
)

REM NMEM=0: "NMEM = 1" is not included in hoge.lst
REM NMEM=1: "NMEM = 1" is included in hoge.lst
SET NMEM=0
FOR /F "TOKENS=3 USEBACKQ" %%T IN (`FINDSTR /R /C:"^ *NMEM = 1$" "%SAMPLE%.lst"`) DO SET NMEM=%%T
REM copy MPF_multi.command in the Commands folder into the current foloder
IF "%NMEM%"=="1" (
   XCOPY "C:\Program Files\RIETAN_VENUS\Commands\MPF_multi.command" . /D /S /Q /K /Y/
)
EXIT

:elapsed_time
REM Compare two times before and after execution of a program in seconds
IF %AFTER% GTR %BEFORE% (
   REM The calculation has finished on the same day.
   REM Insert "0" before "." if it is absent.
   ECHO scale=8; %AFTER% - %BEFORE% | bc | sed -e "s/^\./0./g" -e "s/^/           Elapsed time = /g" -e "s/$/ s/g" >> temp.txt
) ELSE (
   REM The calculation has finished on the next day.
   ECHO scale=8; 86400.000 - %BEFORE% + %AFTER% | bc | sed -e "s/^\./0./g" -e "s/^/           Elapsed time = /g" -e "s/$/ s/g" >> temp.txt
)
EXIT /B
