@ECHO OFF
@echo =======================================================
@echo This file creates registry entries for GSAS and EXPGUI
@echo = Run this from the directory where GSAS is installed =
@echo =======================================================

REM Get this script's directory; make sure that the path ends 
REM    with a single backslash
set gsasloc=%~dp0\*
set gsasloc=%gsasloc:\\*=\*%
set gsasloc=%gsasloc:\*=\%

REM test if representative files are found
IF NOT EXIST %gsasloc%gsas.ico GOTO IconNotFound
IF NOT EXIST %gsasloc%exe  GOTO EXENotFound
IF NOT EXIST %gsasloc%exe\ncnrpack.exe  GOTO TclNotFound


REM changed from HKLM to HKCU due to problems on Vista(?)
@ECHO ON
reg add HKCU\Software\Classes\.exp /ve /d EXPfile /f
reg add HKCU\Software\Classes\EXPfile /v "GSAS experiment file" /d "GSAS Experiment File" /f
reg add HKCU\Software\Classes\EXPfile\DefaultIcon /ve /d %gsasloc%gsas.ico,0 /f
reg add HKCU\Software\Classes\EXPfile\Shell\EXPEDT\command /ve /d "%gsasloc%exe\expedt.exe %%1" /f
reg add HKCU\Software\Classes\EXPfile\Shell\EXPGUI\command /ve /d "%gsasloc%exe\ncnrpack.exe %gsasloc%expgui\expgui ""%%1""" /f
reg add HKCU\Software\Classes\EXPfile\Shell\GENLES\command /ve /d "%gsasloc%exe\genles.exe %%1" /f
reg add HKCU\Software\Classes\EXPfile\Shell\PC-GSAS\command /ve /d "%gsasloc%exe\PC-GSAS.exe %%1" /f
reg add HKCU\Software\Classes\EXPfile\Shell\POWPLOT\command /ve /d "%gsasloc%exe\powplot.exe %%1" /f
reg add HKCU\Software\Classes\EXPfile\Shell\POWPREF\command /ve /d "%gsasloc%exe\powpref.exe %%1" /f

REM The following command can be edited to select the default command when a .EXP file is double clicked
REM Choices are EXPGUI, EXPEDT, GENLES, PS-GSAS, POWPREF or POWPLOT
reg add HKCU\Software\Classes\EXPfile\Shell /ve /d EXPGUI /f

pause
exit

:IconNotFound
echo Error: File %gsasloc%gsas.ico was not found. Was this batch file run from a location other than the GSAS directory?
pause
	exit

:EXENotFound
echo ERROR: Directory %gsasloc%exe was not found. Was this batch file run from a location other than the GSAS directory?
pause
exit

:TclNotFound
echo ERROR: File %gsasloc%exe\ncnrpack.exe was not found. Was this batch file run from a location other than the GSAS directory?
pause
exit

